const float invPi = 1.0 / pi;

const float zenithOffset = 0.1;
const float multiScatterPhase = 0.1;
const float density = 0.7;

const float anisotropicIntensity = 0.0; //Higher numbers result in more anisotropic scattering

const vec3 skyColor = vec3(0.39, 0.57, 1.0) * (1.0 + anisotropicIntensity); //Make sure one of the conponents is never 0.0

#define smooth(x) x*x*(3.0-2.0*x)
#define zenithDensity(x) density / pow(max(x - zenithOffset, 0.35e-2), 0.75)

vec3 getSkyAbsorption(vec3 x, float y){

    vec3 absorption = x * -y;
    absorption = exp2(absorption) * 2.0;

    return absorption;
}

float getSunPoint(vec2 p, vec2 lp){
    return smoothstep(0.03, 0.026, distance(p, lp)) * 50.0;
}

float getRayleigMultiplier(vec2 p, vec2 lp){
    return 1.0 + pow(1.0 - clamp(distance(p, lp), 0.0, 1.0), 2.0) * pi * 0.5;
}

float getMie(vec2 p, vec2 lp){
    float disk = clamp(1.0 - pow(distance(p, lp), 0.1), 0.0, 1.0);

    return disk*disk*(3.0 - 2.0 * disk) * 2.0 * pi;
}

vec3 getAtmosphericScattering(vec2 p, vec2 lp){
    vec2 correctedLp = lp;

    float zenith = zenithDensity(p.y);
    float sunPointDistMult =  clamp(length(max(correctedLp.y + multiScatterPhase - zenithOffset, 0.0)), 0.0, 1.0);

    float rayleighMult = getRayleigMultiplier(p, correctedLp);

    vec3 absorption = getSkyAbsorption(skyColor, zenith);
    vec3 sunAbsorption = getSkyAbsorption(skyColor, zenithDensity(correctedLp.y + multiScatterPhase));
    vec3 sky = skyColor * zenith * rayleighMult;
    vec3 sun = getSunPoint(p, correctedLp) * absorption;
    vec3 mie = getMie(p, correctedLp) * sunAbsorption;

    vec3 totalSky = mix(sky * absorption, sky / (sky + 0.5), sunPointDistMult);
    totalSky += sun + mie;
    totalSky *= sunAbsorption * 0.5 + 0.5 * length(sunAbsorption);

    return totalSky;
}

// --------------------- //
// --------- SH -------- //
// --------------------- //

//struct SH {
//    vec3 l00;
//
//    vec3 l1m1;
//    vec3 l10;
//    vec3 l11;
//
//    vec3 l2m2;
//    vec3 l2m1;
//    vec3 l20;
//    vec3 l21;
//    vec3 l22;
//};
//const int ORDER = 2;
//
//// basis fn
//float Y(vec3 p, int l, int m){
//    if(l == 0){
//        return sqrt(1./pi) * 1./2.;
//    } else if(l == 1){
//        if(m == -1){
//            return p.y * sqrt(3./pi) * 1./2.
//            //* -1.0
//            ;
//        } else if(m == 0){
//            return p.z * sqrt(3./pi) * 1./2.;
//        } else if(m == 1){
//            return p.x * sqrt(3./pi) * 1./2.
//            //* -1.0
//            ;
//        }
//    } else if (l == 2){
//        if(m == -2){
//            return p.y * p.x * sqrt(15./pi) * 1./2.;
//        } else if(m == -1){
//            return p.z * p.y * sqrt(15./pi) * 1./2.
//            // * -1.0
//            ;
//        } else if(m == 0){
//            return (3. * p.z * p.z - 1.0) * sqrt(5./pi) * 1./4.;
//        } else if(m == 1){
//            return p.z * p.x * sqrt(15./pi) * 1./2.
//            //* -1.0
//            ;
//        } else if(m == 2){
//            return (p.x*p.x - p.y*p.y) * sqrt(15./pi) * 1./4.;
//        }
//    } else {
//        return 0.;
//    }
//    return 0.0;
//}
//
//
//SH mul_sh(SH a, SH b){
//    SH c;
//
//    c.l00 = a.l00 * b.l00;
//    c.l1m1 = a.l1m1 * b.l1m1;
//    c.l10 = a.l10 * b.l10;
//    c.l11 = a.l11 * b.l11;
//    c.l2m2 = a.l2m2 * b.l2m2;
//    c.l2m1 = a.l2m1 * b.l2m1;
//    c.l20 = a.l20 * b.l20;
//    c.l21 = a.l21 * b.l21;
//    c.l22 = a.l22 * b.l22;
//
//    return c;
//}
//
//void encode_sh(vec3 C, vec3 r, inout SH sh){
//    //C = clamp(C,0.0,1.0);
//    C = abs(C);
//    //C = max(C,0.00001);
//    sh.l00 += C*Y(r,0,0);
//
//    sh.l1m1 += C*Y(r,1,-1);
//    sh.l10 += C*Y(r,1,0);
//    sh.l11 += C*Y(r,1,1);
//
//    sh.l2m2 += C*Y(r,2,-2);
//    sh.l2m1 += C*Y(r,2,-1);
//    sh.l20 += C*Y(r,2,0);
//    sh.l21 += C*Y(r,2,1);
//    sh.l22 += C*Y(r,2,2);
//}
//
//
//SH decode_sh_coeff(vec3 r, SH sh){
//
////    vec3 C = vec3(0);
//
//    vec3 a = vec3(0);
//    vec3 b = vec3(0);
//    vec3 c = vec3(0);
//    vec3 d = vec3(0);
//    vec3 e = vec3(0);
//    vec3 f = vec3(0);
//    vec3 g = vec3(0);
//    vec3 h = vec3(0);
//    vec3 i = vec3(0);
//
//    if(ORDER >= 0){
//        a += sh.l00 * Y(r,0,0);
//    }
//
//    if(ORDER >= 1){
//        b += sh.l1m1 * Y(r,1,-1);
//        c += sh.l10 * Y(r,1,0);
//        d += sh.l11 * Y(r,1,1);
//    }
//
//    if(ORDER >= 2){
//        e += sh.l2m2 * Y(r,2,-2);
//        f += sh.l2m1 * Y(r,2,-1);
//        g += sh.l20 * Y(r,2,0);
//        h += sh.l21 * Y(r,2,1);
//        i += sh.l22 * Y(r,2,2);
//    }
//    if(false){
//        if(true){
//            i *= 0.;
//            h *= 0.;
//            g *= 0.04;
//            f *= 0.0;
//            e *= -0.13;
//            b *= 2.09;
//            c *= 0.785;
//            d *= 0.;
//            a *= 3.14;
//        } else {
//            a *= pi;
//
//            float aHat1 = 2.09439;
//            b *= 2.*pi/3.0;
//            c *= 2.*pi/3.0;
//            d *= 2.*pi/3.0;
//
//            e *= pi/4.0;
//            f *= pi/4.0;
//            g *= pi/4.0;
//            h *= pi/4.0;
//            i *= pi/4.0;
//        }
//
//
//    }
//
////    C += a + b + c + d + e + f + g + h + i;
//    //C *= 2.5;
//    return SH(
//        a,b,c,d,e,f,g,h,i
//    );
//}
//vec3 decode_sh(vec3 r, SH sh){
//
//    vec3 C = vec3(0);
//
//    vec3 a = vec3(0);
//    vec3 b = vec3(0);
//    vec3 c = vec3(0);
//    vec3 d = vec3(0);
//    vec3 e = vec3(0);
//    vec3 f = vec3(0);
//    vec3 g = vec3(0);
//    vec3 h = vec3(0);
//    vec3 i = vec3(0);
//
//    if(ORDER >= 0){
//        a += sh.l00 * Y(r,0,0);
//    }
//
//    if(ORDER >= 1){
//        b += sh.l1m1 * Y(r,1,-1);
//        c += sh.l10 * Y(r,1,0);
//        d += sh.l11 * Y(r,1,1);
//    }
//
//    if(ORDER >= 2){
//        e += sh.l2m2 * Y(r,2,-2);
//        f += sh.l2m1 * Y(r,2,-1);
//        g += sh.l20 * Y(r,2,0);
//        h += sh.l21 * Y(r,2,1);
//        i += sh.l22 * Y(r,2,2);
//    }
//    if(false){
//        if(true){
//            i *= 0.;
//            h *= 0.;
//            g *= 0.04;
//            f *= 0.0;
//            e *= -0.13;
//            b *= 2.09;
//            c *= 0.785;
//            d *= 0.;
//            a *= 3.14;
//        } else {
//            a *= pi;
//
//            float aHat1 = 2.09439;
//            b *= 2.*pi/3.0;
//            c *= 2.*pi/3.0;
//            d *= 2.*pi/3.0;
//
//            e *= pi/4.0;
//            f *= pi/4.0;
//            g *= pi/4.0;
//            h *= pi/4.0;
//            i *= pi/4.0;
//        }
//
//
//    }
//
//    C += a + b + c + d + e + f + g + h + i;
//    //C *= 2.5;
//    return C;
//}
//
//SH sh_cos_lobe(vec3 dir){
//    SH result;
//    result.l00 = vec3(0.8862269254527580137);			// L=0 , M= 0
//    result.l1m1 = vec3(-1.0233267079464884885) * dir.y;	// L=1 , M=-1
//    result.l10 = vec3(1.0233267079464884885) * dir.z;	// L=1 , M= 0
//    result.l11 = vec3(-1.0233267079464884885) * dir.x;	// L=1 , M= 1
//    result.l2m2 = vec3(0);
//    result.l2m1 = vec3(0);
//    result.l20 = vec3(0);
//    result.l21 = vec3(0);
//    result.l22 = vec3(0);
//    return result;
//}
//
//vec3 calcIrradiance(vec3 nor, float sca, SH c) {
//    //const SHCoefficients c = stpeter;
//    const float c1 = 0.429043;
//    const float c2 = 0.511664;
//    const float c3 = 0.743125;
//    const float c4 = 0.886227;
//    const float c5 = 0.247708;
//
//    return (
//    c1 * c.l22 * (nor.x * nor.x - nor.y * nor.y) +
//    c3 * c.l20 * nor.z * nor.z +
//    c4 * c.l00 -
//    c5 * c.l20 +
//    2.0 * c1 * c.l2m2 * nor.x * nor.y +
//    2.0 * c1 * c.l21  * nor.x * nor.z +
//    2.0 * c1 * c.l2m1 * nor.y * nor.z +
//    2.0 * c2 * c.l11  * nor.x +
//    2.0 * c2 * c.l1m1 * nor.y +
//    2.0 * c2 * c.l10  * nor.z
//    ) * sca;
//}
//vec3 Evaluate(vec3 dir, SH sh) {
//    const float c1 = 0.42904276540489171563379376569857;
//    const float c2 = 0.51166335397324424423977581244463;
//    const float c3 = 0.24770795610037568833406429782001;
//    const float c4 = 0.88622692545275801364908374167057;
//    dir = vec3(-1,1,1)*dir.xyz;
//    vec3 _SH[9];
//
//    _SH[0] = sh.l00;
//    _SH[1] = sh.l1m1;
//    _SH[2] = sh.l10;
//    _SH[3] = sh.l11;
//    _SH[4] = sh.l2m2;
//    _SH[5] = sh.l2m1;
//    _SH[6] = sh.l20;
//    _SH[7] = sh.l21;
//    _SH[8] = sh.l22;
//
//    return  0.6*max(vec3(0.0),
//    +  c4 * _SH[0]                                                                           //   c4  L00
//    +  c2 * 2.0 * (_SH[3] * dir.x + _SH[1]* dir.y + _SH[2]* dir.z)                           // 2 c2 (L11 x + L1-1 y + L10 z)
//    +  c1 * 2.0 * (_SH[4] * dir.x * dir.y + _SH[7] * dir.x * dir.z + _SH[5] * dir.y * dir.z) // 2 c1 (L2-2 xy + L21 xz + L2-1 yz)
//    + (c1 * (dir.x * dir.x - dir.y * dir.y)) * _SH[8]                                        //   c1 L22 (x-y)
//    + (c3 * (3.0 * dir.z * dir.z - 1.0)) * _SH[6]                                            //   c3 L20 (3.z - 1)
//    );
//}

// 4 out, 3 in...

vec3 rand_sphere_dir() {
    float phi = 2.0f * pi * hash_f();
    float z = 1.0f - 2.0f * hash_f();
    float r = sqrt(max(0.0f, 1.0f - z * z));
    return vec3(r * cos(phi), z, r * sin(phi));
}

vec3 rand_cos_hemi(vec3 n){
    return normalize(n + rand_sphere_dir());
}


vec3 randHemi(vec3 n){
    vec3 v = rand_sphere_dir();
    if(dot(v,n) < 0.){
        v = -v;
    }
    return v;
}

//float henyey_g = .8; // anisotropy
float henyey_greenstein( float henyey_g){
    float g = henyey_g;
    float sqrTerm = (1.0f - g * g) /
    (1.0f - g + 2.0f * g * hash_f());
    float cosTheta = (1.0f + g * g - sqrTerm * sqrTerm) / (2.0f * g);
    return cosTheta;
}

vec3 sample_hemisphere(float th, float phi){
    return vec3(
        sin(phi*tau) * sin(th),
        cos(phi*tau) * sin(th),
        cos(th)
    );
}


void basis(in vec3 n, out vec3 f, out vec3 r) {
    if(n.z < -0.999999) {
        f = vec3(0 , -1, 0);
        r = vec3(-1, 0, 0);
    } else {
        float a = 1./(1. + n.z);
        float b = -n.x*n.y*a;
        f = vec3(1. - n.x*n.x*a, b, -n.x);
        r = vec3(b, 1. - n.y*n.y*a , -n.y);
    }
}

mat3 get_orth_basis(in vec3 n) {
    vec3 x;
    vec3 y;
    basis(n, x, y);
    return mat3(x,y,n);
}

